-- Typ für Bedarfsverursacher mit zugehöriger Bedarfsmenge
CREATE TYPE tartikel.bedarf_verursacher AS (
  type_index SMALLINT,      -- 1: auftg; 2: bestanfpos
  id         INTEGER,
  qty        NUMERIC(12,4)
);

CREATE TYPE tartikel.ask_ksbelast_type AS (ks VARCHAR, zeit_stu NUMERIC);

DO $$
BEGIN
    IF NOT EXISTS (SELECT 1 FROM pg_type WHERE typname = 'prodat_deprecated') THEN
        CREATE TYPE Z_99_Deprecated.prodat_deprecated AS
        (
            x BOOLEAN --TYP für deprecated Functions, diese werden mit Default NULL im Function-Header aufgenommen und droppen sich somit in Abhängigkeit des Typs oder Schema
        );
    END IF;
    --more types here...
END$$;

CREATE TYPE tplanterm.abginterm_returntype AS (startdate TIMESTAMP(0) WITHOUT TIME ZONE, enddate TIMESTAMP(0) WITHOUT TIME ZONE, ulapdate DATE);
CREATE TYPE ks_getkapatodate_type AS (ks_kapa NUMERIC, ks_belast NUMERIC);
--
CREATE TYPE tartikel.bedarf_prognose_returntype AS (type INTEGER, date DATE, dateyearmonth VARCHAR, menge NUMERIC(12,4), ptyp INTEGER, descr VARCHAR, bapid INTEGER, bapparentid INTEGER, parentaknrmenge TEXT, mengeauftg NUMERIC(12,4), bewegung NUMERIC(12,4), pos INTEGER);


-- Grundlegende Typdefinition für CompositeType der Preise hält.
CREATE TYPE TWawi.Preis AS (
  -- Wieviel
  IsValid               BOOLEAN,          -- Workaround wegen fehlener NULL-Prüfung für CompositeTypes
  preis                 NUMERIC(16,4),    -- Angezeigter Preis, ggf. in anderer Mengeneinheit und abweichender Währung, Preis unter Berücksichtung der Preiseinheit, Bsp: 4,99€ pro 100 Stk. => 4,99€
  preis_uf1             NUMERIC(16,4),    -- Preis pro Grundmengeneinheit, ggf. in Fremdwährung. Preiseinheit rausgerechnet => 4,99€ per 100 Stk => 0,0499
  preis_uf1_basisw      NUMERIC(16,4),    -- Preis pro Grundmengeneinheit, in Eigenwährung
  preis_uf1_basisw_abzu NUMERIC(16,4),    -- Preis pro Grundmengeneinheit, in Eigenwährung inklusive Rabatt und Ab- und zuschläge (Damit vergleichbar, wird in preis_uf1_basisw der Rabatt eingerechnet, dann Abzu oben drauf, Abzu gelten immer pro Stück. )
  menge                 NUMERIC(16,4),    -- Menge auf die sich der Preis im Preisursprung bezog, in Ursprungs-ME (z.Bsp. Rahmenmenge, Angefragte Menge im Angebot, verrechnete Menge in ERG etc.)
  menge_los             NUMERIC(16,4),    -- Menge die von der Preissuche vorschlagen würde, in Urpsrungs-ME, ggf. mit Losrundung
  -- Wer / Wofür / Wann
  ad_krz                VARCHAR(21),      -- Lieferant (oder Kunde) von / für den der Preis geholt wurde
  ak_nr                 VARCHAR(40),      -- Artikel oder Arbeitspaket für das der Preis erfasst wurde
  datum                 DATE,             -- Datum des Preises
  datum_bis             DATE,
  -- Warum
  rabatt                NUMERIC(5,2),     -- Rabatt der noch auf "Preis" gerechnet wird
  los                   NUMERIC(12,2),    -- Losgröße / Menge auf die sich der Preis bezieht (in ME des Preises)
  kurs                  NUMERIC(12,6),    -- Zugrunde gelegter Kurs, wenn eine Fremdwährung benutzt wurde
  steuproz              NUMERIC(5,2),     -- Prozentsatz Steuern
  -- Wie
  artmgcid              INTEGER,          -- Verwendete Mengeneinheit
  wacode                VARCHAR(3),       -- Verwendete Währung
  steucode              INTEGER,          -- Verwendeter Steuercode
  hasAbzu               BOOLEAN,          -- Flag zur schnellen Abfrage ob Ab- und Zuschläge zum Preis vorhanden sind
  -- Woher
  source_bez            VARCHAR(100),     -- Menschenlesbare Bezeichnung (Übersetzung) der Preisquelle
  source_table          VARCHAR(40),      -- Quelltabelle, aus der der Preis stammt
  source_dbrid          VARCHAR(32),      -- DBRID des Quelldatensatzes aus dem der Preis stammt
  minPreis              NUMERIC(16,4),    -- Der günstigste Preis der für diesen Artikel gefunden wurde
  maxPreis              NUMERIC(16,4),    -- Der teuerste Preis der für diesen Artikel gefunden wurde
  abzubetrag_uf1_basisw NUMERIC(12,6),    -- Ab- und Zuschläge pro GME
  aknr_referenz         VARCHAR(50),      -- Referenz-Artikelnummer, z.Bsp. vom Lieferant oder vom Kunde
  preiseinheit          NUMERIC(14,4),    -- Menge auf die sich der Preis bezieht, also z.Bsp. 4,99€ per 100 Stk => 100
  status_enum           TEXT              -- Statusfeld
);

/* wenn Änderungen an TYPE dann müssen folgende Funktionen neukompiliert werden (Stand 25.07.2019)
-- alle Twawi.Preis nutzenden Funktionen rekompilieren
do $$
begin

execute pg_get_functiondef('twawi.as_defaultf2view'::regproc);
execute pg_get_functiondef('twawi.as_displaytext'::regproc);
execute pg_get_functiondef('twawi.assign_preistobestanfpos'::regproc);
execute pg_get_functiondef('twawi.change_me'::regproc);
execute pg_get_functiondef('twawi.change_waehrung'::regproc);
--execute pg_get_functiondef('twawi.create_preis'::regproc);  wird durch obige Funktion bzw. abgeänderte Funktion im nächsten TC recompiled
execute pg_get_functiondef('twawi.create_preisme'::regproc);
execute pg_get_functiondef('twawi.epreis_update'::regproc);
execute pg_get_functiondef('twawi.format_preis'::regproc);
execute pg_get_functiondef('twawi.change_me'::regproc);
execute pg_get_functiondef('twawi.max_preis'::regproc);
execute pg_get_functiondef('twawi.min_preis'::regproc);
execute pg_get_functiondef('twawi.round_tolos(numeric, twawi.preis)'::regprocedure::oid);
execute pg_get_functiondef('twawi.search_eingrech_preise'::regproc);
execute pg_get_functiondef('twawi.search_ekpreis'::regproc);
execute pg_get_functiondef('twawi.search_ekpreise'::regproc);
execute pg_get_functiondef('twawi.search_ekrahmen'::regproc);
execute pg_get_functiondef('twawi.search_ekrahmen_list'::regproc);
execute pg_get_functiondef('twawi.search_epreis'::regproc);
execute pg_get_functiondef('twawi.search_epreis_list'::regproc);
execute pg_get_functiondef('twawi.search_liefangebot_preise'::regproc);
execute pg_get_functiondef('twawi.search_selbstkosten'::regproc);
end; $$;
*/


CREATE TYPE x_800_enplan.Parameter AS (
  p_type        INTEGER,        -- Sorte: 0 = Tabellenfeld, 1 = EAV, 2 = ... ?
  p_source      VARCHAR(40),    -- 0: Tabelle , 1: 'recnokeyword'
  p_name        VARCHAR(40),    -- 0: Feldname, 1: Parametername
  p_category    VARCHAR(40),    -- 'ART', 'WKZ', 'MAT' oder eine EAV-Gruppe, unterscheidet z.B. Fertigungsartikel, Material und Werkzeug auf gleiche Tabelle
  p_dbrid       VARCHAR(32),    -- 0: Dbrid des Datensatzes 1: Dbrid des Kopfdatensatzes (r_dbrid)
  p_value       NUMERIC(20,8)  -- Wert
 );
--

-- Standard-Rückgaben von BDE-Informationen
CREATE TYPE TPersonal.bde__status AS (
  -- Mitarbeiter und Zeitpunkt der Erfassung
  bs_minr                     integer,          -- Mitarbeiter
  bs_time                     timestamp,        -- Zeitpunkt der Infos

  -- Zustand aktuell
  bs_is_present               boolean,          -- ist anwesend
  bs_abw_id                   integer,          -- ist abwesend mit Abwesenheit (103 = Raucherpause, 110 = Pause u.a.)
  bs_abw_seit                 timestamp,        -- letzter Eintrag zur Abwesenheit (Datum und Urzeit bei Pause/Raucherpause)
  bs_bd_end_anf_last          timestamp,        -- letzte Ab- oder Anstempelung ungerundet
  bs_bd_end_anf_rund_last     timestamp,        -- letzte Ab- oder Anstempelung gerundet
  bs_bd_minr_is_last_present  boolean,          -- ist letzter MA, der angestempelt ist (macht das Licht aus)

  -- Daten am individ. Werktag
  bs_bd_anf_rund_firstofday   timestamp,        -- erste Anstempelung
    -- TODO: bs_pre_zeit_soll            numeric(12,4),    -- Soll-Stunden der Präsenzzeit
    -- TODO: bs_abw_zeit_soll            numeric(12,4),    -- Soll-Stunden der Abwesenheit
  bs_pre_zeit_ist             numeric(12,4),    -- Ist-Stunden der Präsenzzeit,         aktuell: Summe über bd_saldo, also schon abzgl. bd_gleitpause und bd_blockpause
  bs_abw_zeit_ist             numeric(12,4),    -- Ist-Stunden der Abwesenheit,         aktuell: Summe über bdab_stu
  bs_raucherpausen_ist        numeric(12,4),    -- Ist-Stunden der Raucherpause,        aktuell: TPersonal.bdep__raucherpausen_summe__get(minr, current_wt)
  bs_arbeitszeit_ist          numeric(12,4),    -- Ist-Stunden der Arbeitszeit,         aktuell: Präsenzzeit abzgl. Abwesenheit und Raucherpausen
    -- TODO: bs_pre_zeit_saldo           numeric(12,4),    -- Saldo der Präsenzzeit (Soll - Ist - (autom.) Pausen)

  -- Konto gesamt
  bs_konto_stunden            numeric(12,2),    -- aktuelles Stundenkonto in Stunden,   aktuell: llv__mitpln__ll_stuko__stundenkonto__calc{TPersonal.llv__mitpln__ll_stuko__stundenkonto__calc (get_stundenkonto)}(minr, current_date)
  bs_konto_urlaub             numeric(12,2),    -- aktuelles Urlaubskonto in Tagen,     aktuell: tpersonal.llv_urlaub_act(minr, true)
  bs_konto_raucherpausen      numeric(12,2)     -- unverbuchte Raucherpausen in Stunden aktuell: tpersonal.llv__bdpab__rpause__round(minr, min(bdab_anf), current_date, true)
);


-- Abwesenheits-Bewilligungen, mögliche Operationen
-- für effektive Rechte-Ermittlung
CREATE TYPE TPersonal.bde__abwbew_operation AS ENUM (
  'add',             -- neu erstellen
  'delete',          -- bestehende löschen
  'edit',            -- bestehende bearbeiten (Grund, Zeitraum; nicht Wer bzw. genehmigen/ablehnen)
  'markforapproval', -- vorläufig genehmigen (wenn mehrstufig)
  'approve',         -- genehmigen
  'deny',            -- ablehnen
  'revoke'           -- bereits entschiedenes revidieren
 );
